﻿IF EXISTS (SELECT 1 FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[VX_TR_StratumModifLog_Update]'))
	DROP TRIGGER [dbo].[VX_TR_StratumModifLog_Update]
GO

CREATE TRIGGER [dbo].[VX_TR_StratumModifLog_Update]
	ON [dbo].[Stratum]
	AFTER UPDATE
AS
BEGIN
	SET NOCOUNT ON;
	IF (UPDATE([StrStratum]) OR UPDATE([IncrementValue]))
	BEGIN
		INSERT INTO [dbo].[StratumModifLog] (
			[Respondent],
			[QuotaId],
			[OldStratum],
			[Stratum],
			[OldIncrementValue],
			[IncrementValue],
			[AppName],
			[DateTime]
		)
		SELECT
			inserted.[StrRespondent],
			inserted.[StrQuotaId],
			deleted.[StrStratum],
			inserted.[StrStratum],
			deleted.[IncrementValue],
			inserted.[IncrementValue],
			APP_NAME(),
			GETUTCDATE()
		FROM inserted
		INNER JOIN deleted
			ON inserted.[StrRespondent] = deleted.[StrRespondent]
			AND inserted.[StrQuotaId] = deleted.[StrQuotaId]
		WHERE inserted.[StrStratum] <> deleted.[StrStratum]
			OR inserted.[IncrementValue] <> deleted.[IncrementValue];
	END
END
GO
